/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.crypt;

import java.io.Serializable;
import java.util.UUID;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.crypt.ICryptFactory;
import org.apache.wicket.util.crypt.SunJceCrypt;
import org.apache.wicket.util.lang.Args;

public class KeyInSessionSunJceCryptFactory
implements ICryptFactory {
    private static final MetaDataKey<String> KEY = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    private final String cryptMethod;

    public KeyInSessionSunJceCryptFactory() {
        this("PBEWithMD5AndDES");
    }

    public KeyInSessionSunJceCryptFactory(String cryptMethod) {
        this.cryptMethod = (String)Args.notNull((Object)cryptMethod, (String)"Crypt method");
    }

    public ICrypt newCrypt() {
        Session session = Session.get();
        session.bind();
        String key = session.getMetaData(KEY);
        if (key == null) {
            key = session.getId() + "." + UUID.randomUUID().toString();
            session.setMetaData(KEY, (Serializable)((Object)key));
        }
        ICrypt crypt = this.createCrypt();
        crypt.setKey(key);
        return crypt;
    }

    protected ICrypt createCrypt() {
        return new SunJceCrypt(this.cryptMethod);
    }
}

