/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system.impl;

import com.pi4j.system.SystemInfo;
import com.pi4j.system.SystemInfoProvider;
import com.pi4j.system.impl.DefaultSystemInfoProvider;
import com.pi4j.util.ExecUtil;
import java.io.IOException;
import java.text.ParseException;

public class RaspiSystemInfoProvider
extends DefaultSystemInfoProvider
implements SystemInfoProvider {
    private long getClockFrequency(String target) throws IOException, InterruptedException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_clock " + target.trim());
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("=", 2);
            return Long.parseLong(parts[1].trim());
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    private boolean getCodecEnabled(String codec) throws IOException, InterruptedException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd codec_enabled " + codec);
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("=", 2);
            return parts[1].trim().equalsIgnoreCase("enabled");
        }
        throw new RuntimeException("Invalid command or response.");
    }

    private float getVoltage(String id) throws IOException, InterruptedException, NumberFormatException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_volts " + id);
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("[=V]", 3);
            return Float.parseFloat(parts[1]);
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    @Override
    public String getModelName() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCpuInfo("model name");
    }

    @Override
    public String getOsFirmwareBuild() throws IOException, InterruptedException, UnsupportedOperationException {
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd version");
        if (result != null) {
            for (String line : result) {
                if (!line.startsWith("version ")) continue;
                return line.substring(8);
            }
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    @Override
    public String getOsFirmwareDate() throws IOException, InterruptedException, ParseException, UnsupportedOperationException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd version");
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            return line;
        }
        throw new UnsupportedOperationException("Invalid command or response.");
    }

    @Override
    public SystemInfo.BoardType getBoardType() throws IOException, InterruptedException, UnsupportedOperationException {
        String revision = this.getRevision();
        long irevision = Long.parseLong(revision, 16);
        long scheme = irevision >> 23 & 1L;
        long ram = irevision >> 20 & 7L;
        long manufacturer = irevision >> 16 & 0xFL;
        long processor = irevision >> 12 & 0xFL;
        long type = irevision >> 4 & 0xFFL;
        long rev = irevision & 0xFL;
        if (scheme == 0L) {
            switch (revision) {
                case "0002": {
                    return SystemInfo.BoardType.ModelB_Rev1_0;
                }
                case "0003": {
                    return SystemInfo.BoardType.ModelB_Rev1_1;
                }
                case "0004": 
                case "0005": 
                case "0006": {
                    return SystemInfo.BoardType.ModelB_Rev2_0;
                }
                case "0007": 
                case "0008": {
                    return SystemInfo.BoardType.ModelA_Rev2_0;
                }
                case "0009": 
                case "000d": 
                case "000e": 
                case "000f": {
                    return SystemInfo.BoardType.ModelB_Rev2_0;
                }
                case "0010": {
                    if (this.getHardware().equalsIgnoreCase("BCM2709")) {
                        return SystemInfo.BoardType.Model2B_Rev1_0;
                    }
                    return SystemInfo.BoardType.ModelB_Plus_Rev1_2;
                }
                case "0011": {
                    return SystemInfo.BoardType.Compute_Module_Rev1_2;
                }
                case "0012": {
                    return SystemInfo.BoardType.ModelA_Plus_Rev1_2;
                }
                case "0013": {
                    return SystemInfo.BoardType.ModelB_Plus_Rev1_2;
                }
                case "0014": {
                    return SystemInfo.BoardType.Compute_Module_Rev1_1;
                }
                case "0015": {
                    return SystemInfo.BoardType.ModelA_Plus_Rev1_1;
                }
            }
            return SystemInfo.BoardType.UNKNOWN;
        }
        if (type == 4L) {
            return SystemInfo.BoardType.Model2B_Rev1_0;
        }
        if (type == 9L) {
            return SystemInfo.BoardType.ModelZero_Rev1_0;
        }
        return SystemInfo.BoardType.UNKNOWN;
    }

    @Override
    public float getCpuTemperature() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        String[] stringArray;
        int n;
        int n2;
        String[] result = ExecUtil.execute("/opt/vc/bin/vcgencmd measure_temp");
        if (result != null && result.length > 0 && (n2 = 0) < (n = (stringArray = result).length)) {
            String line = stringArray[n2];
            String[] parts = line.split("[=']", 3);
            return Float.parseFloat(parts[1]);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float getCpuVoltage() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("core");
    }

    @Override
    public float getMemoryVoltageSDRam_C() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("sdram_c");
    }

    @Override
    public float getMemoryVoltageSDRam_I() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("sdram_i");
    }

    @Override
    public float getMemoryVoltageSDRam_P() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException {
        return this.getVoltage("sdram_p");
    }

    @Override
    public boolean getCodecH264Enabled() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCodecEnabled("H264");
    }

    @Override
    public boolean getCodecMPG2Enabled() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCodecEnabled("MPG2");
    }

    @Override
    public boolean getCodecWVC1Enabled() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getCodecEnabled("WVC1");
    }

    @Override
    public long getClockFrequencyArm() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("arm");
    }

    @Override
    public long getClockFrequencyCore() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("core");
    }

    @Override
    public long getClockFrequencyH264() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("h264");
    }

    @Override
    public long getClockFrequencyISP() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("isp");
    }

    @Override
    public long getClockFrequencyV3D() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("v3d");
    }

    @Override
    public long getClockFrequencyUART() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("uart");
    }

    @Override
    public long getClockFrequencyPWM() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("pwm");
    }

    @Override
    public long getClockFrequencyEMMC() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("emmc");
    }

    @Override
    public long getClockFrequencyPixel() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("pixel");
    }

    @Override
    public long getClockFrequencyVEC() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("vec");
    }

    @Override
    public long getClockFrequencyHDMI() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("hdmi");
    }

    @Override
    public long getClockFrequencyDPI() throws IOException, InterruptedException, UnsupportedOperationException {
        return this.getClockFrequency("dpi");
    }
}

