/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinEdge;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.impl.PinImpl;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class PinProvider {
    protected static Map<String, Pin> pins = new HashMap<String, Pin>();

    protected static Pin createDigitalPin(String providerName, int address, String name) {
        return PinProvider.createDigitalPin(providerName, address, name, EnumSet.allOf(PinEdge.class));
    }

    protected static Pin createDigitalPin(String providerName, int address, String name, EnumSet<PinPullResistance> resistance, EnumSet<PinEdge> edges) {
        return PinProvider.createPin(providerName, address, name, EnumSet.of(PinMode.DIGITAL_INPUT, PinMode.DIGITAL_OUTPUT, PinMode.SOFT_PWM_OUTPUT), resistance, edges);
    }

    protected static Pin createDigitalPin(String providerName, int address, String name, EnumSet<PinEdge> edges) {
        return PinProvider.createPin(providerName, address, name, EnumSet.of(PinMode.DIGITAL_INPUT, PinMode.DIGITAL_OUTPUT, PinMode.SOFT_PWM_OUTPUT), PinPullResistance.all(), edges);
    }

    protected static Pin createDigitalAndPwmPin(String providerName, int address, String name, EnumSet<PinEdge> edges) {
        return PinProvider.createPin(providerName, address, name, EnumSet.of(PinMode.DIGITAL_INPUT, PinMode.DIGITAL_OUTPUT, PinMode.PWM_OUTPUT), PinPullResistance.all(), edges);
    }

    protected static Pin createDigitalAndPwmPin(String providerName, int address, String name) {
        return PinProvider.createDigitalAndPwmPin(providerName, address, name, EnumSet.allOf(PinEdge.class));
    }

    protected static Pin createPin(String providerName, int address, String name, EnumSet<PinMode> modes, EnumSet<PinPullResistance> resistance, EnumSet<PinEdge> edges) {
        PinImpl pin = new PinImpl(providerName, address, name, modes, resistance, edges);
        if (pins == null) {
            pins = new HashMap<String, Pin>();
        }
        pins.put(name, pin);
        return pin;
    }

    public static Pin getPinByName(String name) {
        return pins.get(name);
    }

    public static Pin getPinByAddress(int address) {
        for (Pin pin : pins.values()) {
            if (pin.getAddress() != address) continue;
            return pin;
        }
        return null;
    }

    public static Pin[] allPins() {
        return pins.values().toArray(new Pin[0]);
    }
}

