/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatementBuilder<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementBuilder.class);
    protected final TableInfo<T, ID> tableInfo;
    protected final String tableName;
    protected final DatabaseType databaseType;
    protected final Dao<T, ID> dao;
    protected StatementType type;
    protected boolean addTableName;
    protected Where<T, ID> where = null;

    public StatementBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao, StatementType type) {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.tableName = tableInfo.getTableName();
        this.dao = dao;
        this.type = type;
        if (!type.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)type) + " statement is not allowed");
        }
    }

    public Where<T, ID> where() {
        this.where = new Where<T, ID>(this.tableInfo, this, this.databaseType);
        return this.where;
    }

    public void setWhere(Where<T, ID> where) {
        this.where = where;
    }

    protected MappedPreparedStmt<T, ID> prepareStatement(Long limit) throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        String statement = this.buildStatementString(argList);
        ArgumentHolder[] selectArgs = argList.toArray(new ArgumentHolder[argList.size()]);
        FieldType[] resultFieldTypes = this.getResultFieldTypes();
        FieldType[] argFieldTypes = new FieldType[argList.size()];
        for (int selectC = 0; selectC < selectArgs.length; ++selectC) {
            argFieldTypes[selectC] = selectArgs[selectC].getFieldType();
        }
        if (!this.type.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)this.type) + " statement is not allowed");
        }
        return new MappedPreparedStmt<T, ID>(this.tableInfo, statement, argFieldTypes, resultFieldTypes, selectArgs, this.databaseType.isLimitSqlSupported() ? null : limit, this.type);
    }

    public String prepareStatementString() throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        return this.buildStatementString(argList);
    }

    public StatementInfo prepareStatementInfo() throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        String statement = this.buildStatementString(argList);
        return new StatementInfo(statement, argList);
    }

    public void clear() {
        this.where = null;
    }

    protected String buildStatementString(List<ArgumentHolder> argList) throws SQLException {
        StringBuilder sb = new StringBuilder(128);
        this.appendStatementString(sb, argList);
        String statement = sb.toString();
        logger.debug("built statement {}", (Object)statement);
        return statement;
    }

    protected void appendStatementString(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        this.appendStatementStart(sb, argList);
        this.appendWhereStatement(sb, argList, true);
        this.appendStatementEnd(sb, argList);
    }

    protected abstract void appendStatementStart(StringBuilder var1, List<ArgumentHolder> var2) throws SQLException;

    protected void appendWhereStatement(StringBuilder sb, List<ArgumentHolder> argList, boolean first) throws SQLException {
        if (this.where == null) {
            return;
        }
        if (first) {
            sb.append("WHERE ");
        } else {
            sb.append("AND (");
        }
        this.where.appendSql(this.addTableName ? this.tableName : null, sb, argList);
        if (!first) {
            sb.append(") ");
        }
    }

    protected abstract void appendStatementEnd(StringBuilder var1, List<ArgumentHolder> var2) throws SQLException;

    protected boolean shouldPrependTableNameToColumns() {
        return false;
    }

    protected FieldType[] getResultFieldTypes() {
        return null;
    }

    protected FieldType verifyColumnName(String columnName) {
        return this.tableInfo.getFieldTypeByColumnName(columnName);
    }

    StatementType getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StatementInfo {
        private final String statement;
        private final List<ArgumentHolder> argList;

        private StatementInfo(String statement, List<ArgumentHolder> argList) {
            this.argList = argList;
            this.statement = statement;
        }

        public String getStatement() {
            return this.statement;
        }

        public List<ArgumentHolder> getArgList() {
            return this.argList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatementType {
        SELECT(true, true, false, false),
        SELECT_LONG(true, true, false, false),
        SELECT_RAW(true, true, false, false),
        UPDATE(true, false, true, false),
        DELETE(true, false, true, false),
        EXECUTE(false, false, false, true);

        private final boolean okForStatementBuilder;
        private final boolean okForQuery;
        private final boolean okForUpdate;
        private final boolean okForExecute;

        private StatementType(boolean okForStatementBuilder, boolean okForQuery, boolean okForUpdate, boolean okForExecute) {
            this.okForStatementBuilder = okForStatementBuilder;
            this.okForQuery = okForQuery;
            this.okForUpdate = okForUpdate;
            this.okForExecute = okForExecute;
        }

        public boolean isOkForStatementBuilder() {
            return this.okForStatementBuilder;
        }

        public boolean isOkForQuery() {
            return this.okForQuery;
        }

        public boolean isOkForUpdate() {
            return this.okForUpdate;
        }

        public boolean isOkForExecute() {
            return this.okForExecute;
        }
    }
}

