/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.jni;

import com.pi4j.util.NativeLibraryLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class Serial {
    public static final String DEFAULT_COM_PORT = "/dev/ttyAMA0";
    public static final String FIRST_USB_COM_PORT = "/dev/ttyUSB0";
    public static final String SECOND_USB_COM_PORT = "/dev/ttyUSB1";
    public static int BAUD_RATE_50 = 50;
    public static int BAUD_RATE_75 = 75;
    public static int BAUD_RATE_110 = 110;
    public static int BAUD_RATE_134 = 134;
    public static int BAUD_RATE_150 = 150;
    public static int BAUD_RATE_200 = 200;
    public static int BAUD_RATE_300 = 300;
    public static int BAUD_RATE_600 = 600;
    public static int BAUD_RATE_1200 = 1200;
    public static int BAUD_RATE_1800 = 1800;
    public static int BAUD_RATE_2400 = 2400;
    public static int BAUD_RATE_4800 = 4800;
    public static int BAUD_RATE_9600 = 9600;
    public static int BAUD_RATE_19200 = 19200;
    public static int BAUD_RATE_38400 = 38400;
    public static int BAUD_RATE_57600 = 57600;
    public static int BAUD_RATE_115200 = 115200;
    public static int BAUD_RATE_230400 = 230400;
    public static int PARITY_NONE = 0;
    public static int PARITY_ODD = 1;
    public static int PARITY_EVEN = 2;
    public static int PARITY_MARK = 3;
    public static int PARITY_SPACE = 4;
    public static int DATA_BITS_5 = 5;
    public static int DATA_BITS_6 = 6;
    public static int DATA_BITS_7 = 7;
    public static int DATA_BITS_8 = 8;
    public static int STOP_BITS_1 = 1;
    public static int STOP_BITS_2 = 2;
    public static int FLOW_CONTROL_NONE = 0;
    public static int FLOW_CONTROL_HARDWARE = 1;
    public static int FLOW_CONTROL_SOFTWARE = 2;

    private Serial() {
    }

    public static synchronized native int open(String var0, int var1, int var2, int var3, int var4, int var5) throws IOException;

    public static synchronized int open(String device, int baud, int dataBits, int parity, int stopBits) throws IOException {
        return Serial.open(device, baud, dataBits, parity, stopBits, FLOW_CONTROL_NONE);
    }

    public static synchronized int open(String device, int baud, int dataBits, int parity) throws IOException {
        return Serial.open(device, baud, dataBits, parity, STOP_BITS_1, FLOW_CONTROL_NONE);
    }

    public static synchronized int open(String device, int baud, int dataBits) throws IOException {
        return Serial.open(device, baud, dataBits, PARITY_NONE, STOP_BITS_1, FLOW_CONTROL_NONE);
    }

    public static synchronized int open(String device, int baud) throws IOException {
        return Serial.open(device, baud, DATA_BITS_8, PARITY_NONE, STOP_BITS_1, FLOW_CONTROL_NONE);
    }

    public static synchronized native void close(int var0) throws IOException;

    public static synchronized native void discardInput(int var0) throws IOException;

    public static synchronized native void discardOutput(int var0) throws IOException;

    public static synchronized native void discardAll(int var0) throws IOException;

    public static synchronized native void flush(int var0) throws IOException;

    public static synchronized native void sendBreak(int var0, int var1) throws IOException;

    public static synchronized void sendBreak(int fd) throws IOException {
        Serial.sendBreak(fd, 0);
    }

    public static synchronized native void setBreak(int var0, boolean var1) throws IOException;

    public static synchronized native void setRTS(int var0, boolean var1) throws IOException;

    public static synchronized native void setDTR(int var0, boolean var1) throws IOException;

    public static synchronized native boolean getRTS(int var0) throws IOException;

    public static synchronized native boolean getDTR(int var0) throws IOException;

    public static synchronized native boolean getCTS(int var0) throws IOException;

    public static synchronized native boolean getDSR(int var0) throws IOException;

    public static synchronized native boolean getRI(int var0) throws IOException;

    public static synchronized native boolean getCD(int var0) throws IOException;

    public static synchronized native int available(int var0);

    public static synchronized native byte[] read(int var0) throws IOException;

    public static synchronized native byte[] read(int var0, int var1) throws IOException;

    public static synchronized void read(int fd, ByteBuffer buffer) throws IOException {
        byte[] data = Serial.read(fd);
        buffer.put(data);
    }

    public static synchronized void read(int fd, int length, ByteBuffer buffer) throws IOException {
        buffer.put(Serial.read(fd, length));
    }

    public static synchronized void read(int fd, OutputStream stream) throws IOException {
        stream.write(Serial.read(fd));
    }

    public static synchronized void read(int fd, int length, OutputStream stream) throws IOException {
        stream.write(Serial.read(fd, length));
    }

    public static synchronized void read(int fd, Collection<ByteBuffer> collection) throws IOException {
        collection.add(ByteBuffer.wrap(Serial.read(fd)));
    }

    public static synchronized void read(int fd, int length, Collection<ByteBuffer> collection) throws IOException {
        collection.add(ByteBuffer.wrap(Serial.read(fd)));
    }

    public static synchronized CharBuffer read(int fd, Charset charset) throws IOException {
        return charset.decode(ByteBuffer.wrap(Serial.read(fd)));
    }

    public static synchronized CharBuffer read(int fd, int length, Charset charset) throws IOException {
        return charset.decode(ByteBuffer.wrap(Serial.read(fd, length)));
    }

    public static synchronized void read(int fd, Charset charset, Writer writer) throws IOException {
        writer.write(Serial.read(fd, charset).toString());
    }

    public static synchronized void read(int fd, int length, Charset charset, Writer writer) throws IOException {
        writer.write(Serial.read(fd, length, charset).toString());
    }

    private static synchronized native void write(int var0, byte[] var1, long var2) throws IOException;

    public static synchronized void write(int fd, byte[] data, int offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        System.arraycopy(data, offset, buffer, 0, length);
        Serial.write(fd, buffer, length);
    }

    public static synchronized void write(int fd, byte ... data) throws IOException {
        Serial.write(fd, data, data.length);
    }

    public static synchronized void write(int fd, byte[] ... data) throws IOException {
        for (byte[] single : data) {
            Serial.write(fd, single, single.length);
        }
    }

    public static synchronized void write(int fd, ByteBuffer ... data) throws IOException {
        for (ByteBuffer single : data) {
            byte[] payload = new byte[single.remaining()];
            single.get(payload);
            Serial.write(fd, payload, payload.length);
        }
    }

    public static synchronized void write(int fd, InputStream input) throws IOException {
        int length;
        if (input.available() <= 0) {
            throw new IOException("No available bytes in input stream to write to serial port.");
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((length = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, length);
        }
        buffer.flush();
        Serial.write(fd, buffer.toByteArray(), buffer.size());
    }

    public static synchronized void write(int fd, Charset charset, char[] data, int offset, int length) throws IOException {
        Serial.write(fd, charset, CharBuffer.wrap(data, offset, length));
    }

    public static synchronized void write(int fd, Charset charset, char ... data) throws IOException {
        Serial.write(fd, charset, CharBuffer.wrap(data));
    }

    public static synchronized void write(int fd, char ... data) throws IOException {
        Serial.write(fd, StandardCharsets.US_ASCII, CharBuffer.wrap(data));
    }

    public static synchronized void write(int fd, Charset charset, CharBuffer ... data) throws IllegalStateException, IOException {
        for (CharBuffer single : data) {
            Serial.write(fd, charset.encode(single));
        }
    }

    public static synchronized void write(int fd, CharBuffer ... data) throws IllegalStateException, IOException {
        Serial.write(fd, StandardCharsets.US_ASCII, data);
    }

    public static synchronized void write(int fd, Charset charset, CharSequence ... data) throws IllegalStateException, IOException {
        for (CharSequence single : data) {
            Serial.write(fd, charset.encode(CharBuffer.wrap(single)));
        }
    }

    public static synchronized void write(int fd, CharSequence ... data) throws IllegalStateException, IOException {
        Serial.write(fd, StandardCharsets.US_ASCII, data);
    }

    public static synchronized void write(int fd, Charset charset, Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        for (CharSequence charSequence : data) {
            Serial.write(fd, charset.encode(CharBuffer.wrap(charSequence)));
        }
    }

    public static synchronized void write(int fd, Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        Serial.write(fd, StandardCharsets.US_ASCII, data);
    }

    public static synchronized void writeln(int fd, Charset charset, CharSequence ... data) throws IllegalStateException, IOException {
        for (CharSequence single : data) {
            Serial.write(fd, charset.encode(CharBuffer.wrap(single + "\r\n")));
        }
    }

    public static synchronized void writeln(int fd, CharSequence ... data) throws IllegalStateException, IOException {
        Serial.writeln(fd, StandardCharsets.US_ASCII, data);
    }

    public static synchronized void writeln(int fd, Charset charset, Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        for (CharSequence charSequence : data) {
            Serial.write(fd, charset.encode(CharBuffer.wrap(charSequence + "\r\n")));
        }
    }

    public static synchronized void writeln(int fd, Collection<? extends CharSequence> data) throws IllegalStateException, IOException {
        Serial.writeln(fd, StandardCharsets.US_ASCII, data);
    }

    static {
        NativeLibraryLoader.load("libpi4j.so");
    }
}

