/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol.handler;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.UecsRequest;
import com.wabit.uecs.UecsResponse;
import com.wabit.uecs.protocol.DataCcm;
import com.wabit.uecs.protocol.RequestCcm;
import com.wabit.uecs.protocol.XmlCcm;
import com.wabit.uecs.protocol.handler.AbstractProtocolHandler;

public class DataProtocolHandler
extends AbstractProtocolHandler {
    public DataProtocolHandler(IUecsNode<?> node) {
        super(node);
    }

    @Override
    public int getPort() {
        return 16520;
    }

    @Override
    protected void handleCcm(UecsRequest req, UecsResponse res, XmlCcm ccm) throws Exception {
        if (ccm instanceof DataCcm) {
            this.handleDataCcm(req, res, (DataCcm)ccm);
        } else if (ccm instanceof RequestCcm) {
            this.handleRequestCcm(req, res, (RequestCcm)ccm);
        } else {
            throw new Exception("illegal packet : " + ccm.toString());
        }
    }

    public void handleRequestCcm(UecsRequest req, UecsResponse res, RequestCcm rCcm) {
        for (CcmService sv : this.getNode().listCcmService()) {
            if (!sv.isEnable() || sv.getCcm().getSide() != 'S') continue;
            this.processResponse(req, res, rCcm, sv);
        }
    }

    private void handleDataCcm(UecsRequest req, UecsResponse res, DataCcm rCcm) {
        for (CcmService sv : this.getNode().listCcmService()) {
            if (!sv.isEnable() || sv.getCcm().getSide() != 'R') continue;
            this.processReceive(sv, rCcm);
        }
    }

    private void processResponse(UecsRequest req, UecsResponse res, RequestCcm rCcm, CcmService sv) {
        String data;
        Ccm ccm = sv.getCcm();
        CcmLevel level = ccm.getLevel();
        if (!(level.getCategory() != 'B' || !ccm.getType().equals(rCcm.getType()) || ccm.getRoom() != rCcm.getRoom() && rCcm.getRoom() != 0 || ccm.getRegion() != rCcm.getRegion() && rCcm.getRegion() != 0 || ccm.getOrder() != rCcm.getOrder() && rCcm.getOrder() != 0 || (data = sv.getCcm().getStringValue()) == null || data.length() == 0)) {
            DataCcm dccm = this.createDataCcm(ccm);
            res.setAddress(this.getNode().getBroadcastAddress());
            res.setPort(dccm.getPort());
            res.setData(dccm.toXmlBytes());
        }
    }

    private void processReceive(CcmService ccmSv, DataCcm rCcm) {
        Ccm bCcm = ccmSv.getCcm();
        DataCcm vCcm = (DataCcm)ccmSv.getAcceptCcm();
        if (vCcm == null) {
            vCcm = this.createDataCcm(bCcm);
            vCcm.setRoom(0);
            vCcm.setRegion(0);
            vCcm.setOrder(0);
            vCcm.setPriority(30);
        }
        boolean change = false;
        if (!(!bCcm.getType().equals(rCcm.getType()) || bCcm.getRoom() != rCcm.getRoom() && rCcm.getRoom() != 0 || bCcm.getRegion() != rCcm.getRegion() && rCcm.getRegion() != 0 || bCcm.getOrder() != rCcm.getOrder() && rCcm.getOrder() != 0)) {
            CcmLevel level = bCcm.getLevel();
            if ((level.getCategory() == 'A' || level.getCategory() == 'S') && System.currentTimeMillis() - vCcm.getReceivedTime() <= level.getAvailableTime()) {
                if (vCcm.getPriority() == rCcm.getPriority()) {
                    if (vCcm.getRoom() == rCcm.getRoom() && vCcm.getRegion() == rCcm.getRegion() && vCcm.getOrder() == rCcm.getOrder() && vCcm.getPriority() == rCcm.getPriority()) {
                        if (vCcm.getIpAddress() == null || rCcm.getIpAddress() == null) {
                            change = true;
                        } else {
                            byte[] vip = vCcm.getIpAddress().getAddress();
                            byte[] rip = rCcm.getIpAddress().getAddress();
                            int i = 0;
                            while (i < vip.length) {
                                if (vip[i] < rip[i]) {
                                    change = false;
                                    break;
                                }
                                if (vip[i] > rip[i]) {
                                    change = true;
                                    break;
                                }
                                change = true;
                                ++i;
                            }
                        }
                    } else if (this.calcPriority(bCcm, vCcm) > this.calcPriority(bCcm, rCcm)) {
                        change = true;
                    }
                } else if (vCcm.getPriority() > rCcm.getPriority()) {
                    change = true;
                }
            } else {
                change = true;
            }
        }
        if (change) {
            ccmSv.setAcceptCcm(rCcm);
        }
    }

    private int calcPriority(Ccm bCcm, Ccm ccm) {
        int grade = 0;
        if (bCcm.getRoom() == ccm.getRoom()) {
            grade += 4;
        }
        if (bCcm.getRegion() == ccm.getRegion()) {
            grade += 2;
        }
        if (bCcm.getOrder() == ccm.getOrder()) {
            ++grade;
        }
        return 8 - grade;
    }

    private DataCcm createDataCcm(Ccm ccm) {
        DataCcm dccm = new DataCcm();
        dccm.setUecsVersion(ccm.getUecsVersion());
        dccm.setType(ccm.getType());
        dccm.setRoom(ccm.getRoom());
        dccm.setRegion(ccm.getRegion());
        dccm.setOrder(ccm.getOrder());
        dccm.setPriority(ccm.getPriority());
        dccm.setIpAddress(this.getNode().getIpAddress());
        dccm.setCast(ccm.getCast());
        dccm.setUnit(ccm.getUnit());
        dccm.setValue(ccm.getNumberValue());
        return dccm;
    }
}

