/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device.controller;

import com.wabit.uecs.CcmService;
import com.wabit.uecs.ICcmServiceListener;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.ccm.OprCcm;
import com.wabit.uecs.ccm.RcACcm;
import com.wabit.uecs.ccm.RcMCcm;
import com.wabit.uecs.device.AbstractComponent;
import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.util.PropertyConfig;

public abstract class ControllerComponent<T extends ComponentConfig>
extends AbstractComponent<T>
implements ICcmServiceListener {
    private CcmService oprService;
    private CcmService rcAService;
    private CcmService rcMService;

    public ControllerComponent(String id, T config) {
        super(id, config);
    }

    @Override
    public void setValue(Number value) {
        if (this.rcAService != null) {
            this.rcAService.updateValue(value);
        }
        if (this.rcMService != null) {
            this.rcMService.updateValue(value);
        }
        super.setValue(value);
    }

    public CcmService getOprService() {
        return this.oprService;
    }

    public CcmService getRcAService() {
        return this.rcAService;
    }

    public CcmService getRcMService() {
        return this.rcMService;
    }

    @Override
    public void init(IDevice<?> device) throws Exception {
        this.setDevice(device);
        IUecsNode<?> node = this.getDevice().getNode();
        Object config = this.getConfig();
        String name = ((PropertyConfig)config).getString("ComponentName");
        String ccmInfoName = ((PropertyConfig)config).getString("CcmInfoName", "");
        String ccmNodeType = ((PropertyConfig)config).getString("CcmNodeType", "");
        String unit = ((PropertyConfig)config).getString("CcmUnit");
        int ccmRoom = ((PropertyConfig)config).getInt("CcmRoom", 0);
        int ccmRegion = ((PropertyConfig)config).getInt("CcmRegion", 0);
        int ccmOrder = ((PropertyConfig)config).getInt("CcmOrder", 0);
        int ccmPriority = ((PropertyConfig)config).getInt("CcmPriority", 0);
        int ccmLine = ((PropertyConfig)config).getInt("CcmLine", 0);
        OprCcm oprCcm = new OprCcm(ccmInfoName, ccmNodeType, ccmLine);
        oprCcm.setSide('R');
        oprCcm.setUnit(unit);
        oprCcm.setRoom(ccmRoom);
        oprCcm.setRegion(ccmRegion);
        oprCcm.setOrder(ccmOrder);
        this.oprService = new CcmService(oprCcm);
        this.oprService.setName(name);
        this.oprService.addListener(this);
        node.addCcmService(this.oprService);
        RcACcm rcACcm = new RcACcm(ccmInfoName, ccmNodeType, ccmLine);
        rcACcm.setSide('S');
        rcACcm.setUnit(unit);
        rcACcm.setRoom(ccmRoom);
        rcACcm.setRegion(ccmRegion);
        rcACcm.setOrder(ccmOrder);
        rcACcm.setPriority(ccmPriority);
        this.rcAService = new CcmService(rcACcm);
        this.rcAService.setName(name);
        this.rcAService.setEnable(false);
        node.addCcmService(this.rcAService);
        RcMCcm rcMCcm = new RcMCcm(ccmInfoName, ccmNodeType, ccmLine);
        rcMCcm.setSide('S');
        rcMCcm.setUnit(unit);
        rcMCcm.setRoom(ccmRoom);
        rcMCcm.setRegion(ccmRegion);
        rcMCcm.setOrder(ccmOrder);
        rcMCcm.setPriority(ccmPriority);
        this.rcMService = new CcmService(rcMCcm);
        this.rcMService.setName(name);
        this.rcMService.setEnable(false);
        node.addCcmService(this.rcMService);
        this.onInit();
    }
}

