/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device;

import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.device.DeviceConfig;
import com.wabit.uecs.device.DeviceException;
import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.IDeviceListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDevice<T extends DeviceConfig>
implements IDevice<T> {
    private String id;
    private IUecsNode<?> node;
    private T config;
    private Set<IDeviceListener> listeners = Collections.synchronizedSet(new HashSet());
    private Map<String, IComponent<?>> components = new LinkedHashMap();

    public AbstractDevice(String id, T config) {
        this.id = id;
        this.config = config;
    }

    @Override
    public void addListener(IDeviceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public List<IDeviceListener> getListeners() {
        return new ArrayList<IDeviceListener>(this.listeners);
    }

    @Override
    public boolean removeListener(IDeviceListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IUecsNode<?> getNode() {
        return this.node;
    }

    @Override
    public T getConfig() {
        return this.config;
    }

    @Override
    public IComponent<?> getComponent(String componentId) {
        return this.components.get(componentId);
    }

    @Override
    public void addComponent(IComponent<?> component) {
        if (component != null) {
            this.components.put(component.getId(), component);
        }
    }

    @Override
    public List<IComponent<?>> listComponents() {
        return new ArrayList(this.components.values());
    }

    @Override
    public <U extends IComponent<?>> List<U> listComponents(Class<U> cls) {
        ArrayList list = new ArrayList();
        for (IComponent<?> compo : this.listComponents()) {
            if (!cls.isInstance(compo)) continue;
            list.add(compo);
        }
        return list;
    }

    @Override
    public IComponent<?> removeComponent(String componentId) {
        return this.components.remove(componentId);
    }

    @Override
    public void init(IUecsNode<?> node) throws DeviceException {
        this.node = node;
        try {
            this.onInit();
        }
        catch (Exception e) {
            this.notifyException(e);
            throw new DeviceException(e);
        }
        for (IComponent<?> comp : this.components.values()) {
            try {
                comp.init(this);
            }
            catch (Exception e) {
                this.notifyException(e);
                throw new DeviceException(e);
            }
        }
    }

    @Override
    public void start() throws DeviceException {
        try {
            this.onStart();
        }
        catch (Exception exception) {
            this.notifyException(exception);
            throw new DeviceException(exception);
        }
        for (IDeviceListener iDeviceListener : this.listeners) {
            iDeviceListener.deviceStarted(this);
        }
        for (IComponent iComponent : this.components.values()) {
            try {
                iComponent.start();
            }
            catch (Exception e) {
                this.notifyException(e);
                throw new DeviceException(e);
            }
        }
    }

    @Override
    public void stop() throws DeviceException {
        for (IComponent<?> comp : this.components.values()) {
            try {
                comp.stop();
            }
            catch (Exception e) {
                this.notifyException(e);
                throw new DeviceException(e);
            }
        }
        try {
            this.onStop();
        }
        catch (Exception e) {
            throw new DeviceException(e);
        }
        for (IDeviceListener listener : this.listeners) {
            listener.deviceStopped(this);
        }
    }

    protected void notifyStarted() {
        for (IDeviceListener listener : this.listeners) {
            listener.deviceStarted(this);
        }
    }

    protected void notifyStopped() {
        for (IDeviceListener listener : this.listeners) {
            listener.deviceStopped(this);
        }
    }

    protected void notifyException(Exception e) {
        for (IDeviceListener listener : this.listeners) {
            listener.handleDeviceException(this, e);
        }
    }

    protected abstract void onInit() throws Exception;

    protected abstract void onStart() throws Exception;

    protected abstract void onStop() throws Exception;
}

