/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs;

import com.wabit.uecs.CcmID;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.NodeConfig;
import com.wabit.uecs.protocol.DataCcm;
import com.wabit.uecs.protocol.RequestCcm;
import com.wabit.uecs.protocol.XmlCcm;
import com.wabit.uecs.protocol.XmlCcmParser;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class UecsDataServiceTest {
    private IUecsNode node;
    private DatagramSocket sendSocket;
    private DatagramSocket dataSocket;
    private byte[] buffer = new byte[512];

    @Before
    public void setup() throws Exception {
        NodeConfig conf = new NodeConfig("conf/node-config-sender.xml");
        this.sendSocket = new DatagramSocket();
        this.sendSocket.setReceiveBufferSize(512);
        this.dataSocket = new DatagramSocket(16525);
        List<CcmService> list = this.node.listCcmService();
        list.get(0).getAcceptCcm().setValue("32.00");
        this.node.start();
    }

    @After
    public void end() throws Exception {
        this.sendSocket.close();
        this.dataSocket.close();
        this.node.stop();
    }

    private XmlCcm receive() throws Exception {
        DatagramPacket rpacket = new DatagramPacket(this.buffer, this.buffer.length);
        this.dataSocket.receive(rpacket);
        int start = rpacket.getOffset();
        int len = rpacket.getLength();
        byte[] rdata = new byte[len];
        System.arraycopy(this.buffer, start, rdata, 0, len);
        XmlCcmParser ccmParser = new XmlCcmParser();
        return ccmParser.parseBytes(rdata);
    }

    @Test
    public void test1() throws Exception {
        RequestCcm req = new RequestCcm();
        req.setType(new CcmID("SoilTemp.mIC"));
        req.setRoom(3);
        req.setRegion(2);
        req.setOrder(1);
        System.out.println("send:" + req);
        byte[] sdata = req.toXmlBytes();
        DatagramPacket spacket = new DatagramPacket(sdata, sdata.length, this.node.getBroadcastAddress(), 16520);
        this.sendSocket.send(spacket);
        DataCcm server = (DataCcm)this.receive();
        System.out.println("receive:" + server);
        Assert.assertTrue((String)"compare", (boolean)true);
    }
}

