/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui.log;

import com.wabit.uecs.pi.UecsPiLogger;
import com.wabit.uecs.pi.db.LogEntity;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.LayoutPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

@AuthorizeInstantiation(value={"ADMIN"})
public class LogPage
extends LayoutPage {
    private static final long serialVersionUID = 3408233779384475934L;
    private static final String CATEGORY_ALL = "ALL";
    private static final int LIST_SIZE = 100;
    private ListView<LogEntity> logListView;
    private String category;

    protected void onInitialize() {
        super.onInitialize();
        List<String> choiceList = this.getCategoryList();
        if (choiceList != null && choiceList.size() > 0) {
            this.category = choiceList.get(0);
        }
        DropDownChoice<String> categoryChoice = new DropDownChoice<String>("selectedCategory", (IModel)Model.of((Serializable)((Object)this.category)), choiceList){
            private static final long serialVersionUID = 1L;

            protected boolean localizeDisplayValues() {
                return true;
            }

            protected boolean wantOnSelectionChangedNotifications() {
                return true;
            }

            protected void onSelectionChanged(String selected) {
                LogPage.this.category = selected;
                LogPage.this.logListView.modelChanging();
                LogPage.this.logListView.setModelObject(LogPage.this.fetchLogs(LogPage.this.category, 100));
                LogPage.this.logListView.modelChanged();
            }
        };
        this.add(new Component[]{categoryChoice});
        StatelessForm form = new StatelessForm("form");
        form.add(new Component[]{new Button("updateButton"){

            public void onSubmit() {
                LogPage.this.logListView.modelChanging();
                LogPage.this.logListView.setModelObject(LogPage.this.fetchLogs(LogPage.this.category, 100));
                LogPage.this.logListView.modelChanged();
            }
        }});
        form.add(new Component[]{new Button("clearButton"){

            public void onSubmit() {
                LogPage.this.logListView.modelChanging();
                UecsPiLogger.clearLogs();
                LogPage.this.logListView.setModelObject(new ArrayList(0));
                LogPage.this.logListView.modelChanged();
                this.success((Serializable)((Object)MessageUtils.getMessage("message.cleared", new Object[0])));
            }
        }});
        this.add(new Component[]{form});
        List<LogEntity> logs = this.fetchLogs(this.category, 100);
        this.logListView = new ListView<LogEntity>("logList", logs){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<LogEntity> item) {
                LogEntity entity = (LogEntity)item.getModelObject();
                item.add(new Component[]{DateLabel.forDatePattern((String)"time", (IModel)Model.of((Serializable)entity.getTime()), (String)"yyyy-MM-dd HH:mm:ss z")});
                item.add(new Component[]{new Label("category", (IModel)new ResourceModel(entity.getCategory()))});
                item.add(new Component[]{new Label("message", entity.getMessage())});
            }
        };
        this.add(new Component[]{this.logListView});
    }

    private List<String> getCategoryList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("NODE");
        list.add("DEVICE");
        list.add("OTHER");
        list.add(CATEGORY_ALL);
        return list;
    }

    private List<LogEntity> fetchLogs(String category, int size) {
        if (CATEGORY_ALL.equals(category)) {
            return UecsPiLogger.getLogs(size);
        }
        return UecsPiLogger.getLogs(category, size);
    }
}

