/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui.ccmlist;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.ccm.OprCcm;
import com.wabit.uecs.ccm.RcACcm;
import com.wabit.uecs.ccm.RcMCcm;
import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.pi.webui.WebUIApplication;
import com.wabit.uecs.pi.webui.ccmlist.CcmRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

@AuthorizeInstantiation(value={"ADMIN"})
public class CcmListPage
extends LayoutPage {
    private static final long serialVersionUID = -1845932392057063711L;
    private final List<CcmRow> ccmList = new ArrayList<CcmRow>();
    public static final String CCM_NAME_CND = "ccmName.cnd";
    public static final String CCM_NAME_OPR = "ccmName.opr";
    public static final String CCM_NAME_rcA = "ccmName.rcA";
    public static final String CCM_NAME_rcM = "ccmName.rcM";
    public static final String CCM_NAME_receive = "ccmName.receive";

    protected void onInitialize() {
        super.onInitialize();
        StatelessForm<CcmListPage> form = new StatelessForm<CcmListPage>("form"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit() {
                this.setResponsePage(((Object)((Object)CcmListPage.this)).getClass());
            }
        };
        this.add(new Component[]{form});
        UecsPiNode node = WebUIApplication.getNodeInstance();
        for (CcmService ccmSv : node.listCcmService()) {
            Ccm ccm = ccmSv.getCcm();
            String ccmName = ccmSv.getName();
            if (ccm instanceof RcACcm) {
                ccmName = String.valueOf(ccmName) + " [rcA]";
            } else if (ccm instanceof RcMCcm) {
                ccmName = String.valueOf(ccmName) + " [rcM]";
            } else if (ccm instanceof OprCcm) {
                ccmName = String.valueOf(ccmName) + " [opr]";
            }
            CcmRow rec = new CcmRow();
            rec.setName(ccmName);
            rec.setType(ccm.getType().toString());
            rec.setLevel(ccm.getLevel().toString());
            rec.setRoom(ccm.getRoom());
            rec.setRegion(ccm.getRegion());
            rec.setOrder(ccm.getOrder());
            rec.setUnit(ccm.getUnit());
            rec.setSide(String.valueOf(ccm.getSide()));
            if (ccmSv.isEnable()) {
                rec.setValue(ccm.getStringValue());
                if (ccmSv.getUpdateTime() > Long.MIN_VALUE) {
                    rec.setUpdateTime(new Date(ccmSv.getUpdateTime()));
                    if (ccmSv.isExpired()) {
                        rec.setExpired("X");
                    }
                }
            }
            this.ccmList.add(rec);
        }
        this.add(new Component[]{new ListView<CcmRow>("ccmList", this.ccmList){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<CcmRow> item) {
                item.add(new Component[]{new Label("idx", (Serializable)Integer.valueOf(item.getIndex() + 1))});
                item.add(new Component[]{new Label("name", ((CcmRow)item.getModelObject()).getName())});
                item.add(new Component[]{new Label("type", ((CcmRow)item.getModelObject()).getType())});
                item.add(new Component[]{new Label("level", ((CcmRow)item.getModelObject()).getLevel())});
                item.add(new Component[]{new Label("room", (Serializable)Integer.valueOf(((CcmRow)item.getModelObject()).getRoom()))});
                item.add(new Component[]{new Label("region", (Serializable)Integer.valueOf(((CcmRow)item.getModelObject()).getRegion()))});
                item.add(new Component[]{new Label("order", (Serializable)Integer.valueOf(((CcmRow)item.getModelObject()).getOrder()))});
                if (((CcmRow)item.getModelObject()).getValue() != null) {
                    item.add(new Component[]{new Label("value", ((CcmRow)item.getModelObject()).getValue())});
                } else {
                    item.add(new Component[]{new Label("value", "--")});
                }
                item.add(new Component[]{new Label("unit", ((CcmRow)item.getModelObject()).getUnit())});
                item.add(new Component[]{new Label("side", ((CcmRow)item.getModelObject()).getSide())});
                if (((CcmRow)item.getModelObject()).getUpdateTime() != null) {
                    item.add(new Component[]{DateLabel.forDatePattern((String)"updateTime", (IModel)Model.of((Serializable)((CcmRow)item.getModelObject()).getUpdateTime()), (String)"yyyy-MM-dd HH:mm:ss")});
                } else {
                    item.add(new Component[]{new Label("updateTime", "--")});
                }
                item.add(new Component[]{new Label("expired", ((CcmRow)item.getModelObject()).getExpired())});
            }
        }});
    }
}

