/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinEventType;
import com.wabit.uecs.pi.device.PiSensorBase;
import com.wabit.uecs.pi.device.gpio.DigitalSensorConfig;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import com.wabit.uecs.pi.webui.WebUIApplication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DigitalSensorBase<T extends DigitalSensorConfig>
extends PiSensorBase<T> {
    public static final String PIN_PULL_UP = PinPullResistance.PULL_UP.name();
    public static final String PIN_PULL_DOWN = PinPullResistance.PULL_DOWN.name();
    public static final String PIN_PULL_OFF = PinPullResistance.OFF.name();
    private GpioPinDigitalInput senseInputPin;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public DigitalSensorBase(String id, T config) {
        super(id, config);
    }

    public Pin getSenseInputPin() {
        DigitalSensorConfig config = (DigitalSensorConfig)this.getConfig();
        String val = config.getString("GpioPinSenseIn");
        if (val != null && !val.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(val);
        }
        return null;
    }

    protected void onStart() throws Exception {
        DigitalSensorConfig config = (DigitalSensorConfig)this.getConfig();
        Pin sensePin = this.getSenseInputPin();
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (!WebUIApplication.getNodeInstance().isDevelopmentMode() && sensePin != null) {
            this.senseInputPin = (GpioPinDigitalInput)((GpioDeviceBase)this.getDevice()).getProvisionedGpioPinInput(sensePin);
            PinPullResistance registance = PinPullResistance.valueOf((String)config.getString("PinPullRegistance", PIN_PULL_OFF));
            if (this.senseInputPin == null) {
                this.senseInputPin = device.provisionDigitalInputPin(sensePin, registance);
            }
            if (this.senseInputPin == null) {
                throw new Exception("GPIO pin not found : " + sensePin);
            }
            this.logger.debug((Object)("sene_input_pin : " + sensePin));
            int debounce = config.getInt("PinInputDebounce", 0);
            if (debounce > 0) {
                this.senseInputPin.setDebounce(debounce);
            }
            device.addListener((GpioPinListener)new GpioPinListenerDigital(){

                public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                    if (event.getEventType() == PinEventType.DIGITAL_STATE_CHANGE) {
                        try {
                            DigitalSensorBase.this.onSensePinStateChanged(event.getState().isHigh());
                        }
                        catch (Exception e) {
                            DigitalSensorBase.this.logger.error((Object)"event process error.", (Throwable)e);
                            DigitalSensorBase.this.notifyException(e);
                        }
                    }
                }
            }, (GpioPinInput)this.senseInputPin);
        }
    }

    protected void onStop() throws Exception {
        if (this.senseInputPin != null) {
            ((GpioDeviceBase)this.getDevice()).unprovisionPin(new GpioPin[]{this.senseInputPin});
            this.senseInputPin = null;
        }
    }

    protected abstract void onSensePinStateChanged(boolean var1) throws Exception;
}

