/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.io.gpio.event.PinEventType;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.pi.device.gpio.AnalogPositioningActuator;
import com.wabit.uecs.pi.device.gpio.AnalogPositioningActuatorConfig;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalogPositioningInterlockAction
implements IActuatorAction,
GpioPinListenerAnalog {
    private AnalogPositioningActuator<?> positioningActuator;
    private double inputRange;
    private Log logger = LogFactory.getLog(this.getClass());

    public void execute(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioPinAnalogInput input = this.positioningActuator.getGpioInputPin();
        if (input != null) {
            int pos = (int)Math.round(input.getValue() / this.inputRange * 100.0);
            this.positioningActuator.setPosition(pos);
        }
    }

    public void onStart(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        if (!(paramActuatorComponent instanceof AnalogPositioningActuator)) {
            throw new IllegalArgumentException("invalid actuator = " + paramActuatorComponent.getClass().getName());
        }
        this.positioningActuator = (AnalogPositioningActuator)paramActuatorComponent;
        this.inputRange = ((AnalogPositioningActuatorConfig)this.positioningActuator.getConfig()).getDouble("AnalogRangeIn", 100.0);
        GpioDeviceBase device = (GpioDeviceBase)this.positioningActuator.getDevice();
        if (this.positioningActuator.getGpioInputPin() != null) {
            device.addListener((GpioPinListener)this, (GpioPinInput)this.positioningActuator.getGpioInputPin());
        }
        this.execute(paramActuatorComponent);
    }

    public void onStop(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioDeviceBase device = (GpioDeviceBase)this.positioningActuator.getDevice();
        if (this.positioningActuator.getGpioInputPin() != null) {
            device.removeListener((GpioPinListener)this, (GpioPinInput)this.positioningActuator.getGpioInputPin());
        }
    }

    public void handleGpioPinAnalogValueChangeEvent(GpioPinAnalogValueChangeEvent event) {
        if (event.getEventType() == PinEventType.ANALOG_VALUE_CHANGE) {
            try {
                this.execute(this.positioningActuator);
            }
            catch (Exception e) {
                this.logger.error((Object)"process faild.", (Throwable)e);
            }
        }
    }
}

