/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi;

import com.wabit.uecs.AbstractUecsNode;
import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.ICcmServiceListener;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.IUecsNodeListener;
import com.wabit.uecs.IUecsProtocolHandler;
import com.wabit.uecs.NodeConfig;
import com.wabit.uecs.NodeRuntimeException;
import com.wabit.uecs.ccm.DateCcm;
import com.wabit.uecs.ccm.TimeCcm;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.pi.UecsPiLogger;
import com.wabit.uecs.pi.UecsPiNodeConfig;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.PiDeviceBase;
import com.wabit.uecs.protocol.handler.DataProtocolHandler;
import com.wabit.uecs.protocol.handler.ScanProtocolHandler;
import com.wabit.uecs.protocol.handler.SearchProtocolHandler;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeZone;

public class UecsPiNode
extends AbstractUecsNode<UecsPiNodeConfig> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean developmentMode;
    private boolean configEditing;
    private boolean receiveDateTime;
    private boolean timeAdjusted;

    public UecsPiNode() {
        this(new UecsPiNodeConfig());
    }

    public UecsPiNode(UecsPiNodeConfig config) {
        super((NodeConfig)config);
        this.addProtocol((IUecsProtocolHandler)new DataProtocolHandler((IUecsNode)this));
        this.addProtocol((IUecsProtocolHandler)new SearchProtocolHandler((IUecsNode)this));
        this.addProtocol((IUecsProtocolHandler)new ScanProtocolHandler((IUecsNode)this));
        this.addListener(new UecsPiNodeListener());
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.developmentMode = developmentMode;
    }

    public boolean isConfigEditing() {
        return this.configEditing;
    }

    public void setConfigEditing(boolean configEditing) {
        this.configEditing = configEditing;
    }

    public String getUecsVersion() {
        return "1.00-E10";
    }

    public synchronized void setup() {
        String timezone;
        this.configEditing = false;
        String locale = ((UecsPiNodeConfig)this.getConfig()).getString("Locale");
        if (locale != null && locale.length() > 0) {
            Locale.setDefault(Locale.forLanguageTag(locale));
            this.logger.debug((Object)("set Locale = " + Locale.getDefault().toLanguageTag()));
        }
        if ((timezone = ((UecsPiNodeConfig)this.getConfig()).getString("TimeZone")) != null && timezone.length() > 0) {
            DateTimeZone.setDefault((DateTimeZone)DateTimeZone.forID((String)timezone));
            this.logger.debug((Object)("set TimeZone = " + DateTimeZone.getDefault().getID()));
        }
        super.setup();
        try {
            DatabaseUtils.init();
        }
        catch (SQLException e) {
            this.onStatus(0x4000000);
            this.notifyException(e);
            throw new NodeRuntimeException((Throwable)e);
        }
    }

    public synchronized void start() {
        try {
            if (((UecsPiNodeConfig)this.getConfig()).getBoolean("SendDatetime", false)) {
                DateCcm dateCcm = new DateCcm();
                dateCcm.setSide('S');
                CcmService ccmSv = new CcmService((Ccm)dateCcm);
                ccmSv.setName(String.valueOf(this.getName()) + " [Date]");
                ccmSv.setValue(System.currentTimeMillis(), dateCcm.getNumberValue());
                this.addCcmService(ccmSv);
                TimeCcm timeCcm = new TimeCcm();
                timeCcm.setSide('S');
                ccmSv = new CcmService((Ccm)timeCcm);
                ccmSv.setName(String.valueOf(this.getName()) + " [Time]");
                ccmSv.setValue(System.currentTimeMillis(), timeCcm.getNumberValue());
                this.addCcmService(ccmSv);
            }
            if (((UecsPiNodeConfig)this.getConfig()).getBoolean("ReceiveDatetime", false)) {
                DateTimeCcmListener dtLsn = new DateTimeCcmListener();
                DateCcm dateCcm = new DateCcm();
                dateCcm.setSide('R');
                CcmService ccmSv = new CcmService((Ccm)dateCcm);
                ccmSv.setName(String.valueOf(this.getName()) + " [Date]");
                ccmSv.addListener((ICcmServiceListener)dtLsn);
                this.addCcmService(ccmSv);
                TimeCcm timeCcm = new TimeCcm();
                timeCcm.setSide('R');
                ccmSv = new CcmService((Ccm)timeCcm);
                ccmSv.setName(String.valueOf(this.getName()) + " [Time]");
                ccmSv.addListener((ICcmServiceListener)dtLsn);
                this.addCcmService(ccmSv);
                this.receiveDateTime = true;
            } else {
                this.receiveDateTime = false;
            }
            if (this.receiveDateTime && !this.timeAdjusted) {
                this.onStatus(0x200000);
                for (PiDeviceBase dev : this.listDevices(new Class[]{PiDeviceBase.class})) {
                    dev.setEnabled(false);
                }
            }
            super.start();
        }
        catch (Error e) {
            this.onStatus(0x4000000);
            this.notifyException((Exception)new NodeRuntimeException((Throwable)e));
            throw e;
        }
    }

    public synchronized void stop() {
        super.stop();
    }

    public synchronized void onDestroy() {
    }

    protected void finalize() throws Throwable {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                this.logger.info((Object)String.format("deregistering jdbc driver: %s", driver));
            }
            catch (SQLException e) {
                this.logger.error((Object)String.format("Error deregistering driver %s", driver), (Throwable)e);
            }
        }
        super.finalize();
    }

    public synchronized void restartAsync(long delay) throws Exception {
        if (!DatabaseUtils.isInstalled()) {
            DatabaseUtils.saveNodeConfig(this.getConfig());
            this.installProcess();
        }
        ((UecsPiNodeConfig)this.getConfig()).putAll((Map)DatabaseUtils.loadNodeConfig());
        List<PiDeviceBase<?>> devices = DatabaseUtils.loadDevices();
        Thread th = new Thread(new RestartTask(devices, delay));
        th.start();
    }

    public synchronized void restart() throws Exception {
        this.logger.debug((Object)"restart node.");
        if (this.isActive()) {
            this.stop();
        }
        if (!DatabaseUtils.isInstalled()) {
            DatabaseUtils.saveNodeConfig(this.getConfig());
            this.installProcess();
        }
        ((UecsPiNodeConfig)this.getConfig()).putAll((Map)DatabaseUtils.loadNodeConfig());
        this.setup();
        List<PiDeviceBase<?>> devices = DatabaseUtils.loadDevices();
        for (PiDeviceBase<?> device : devices) {
            this.addDevice((IDevice)device);
        }
        this.start();
    }

    protected void installProcess() throws Exception {
    }

    private class DateTimeCcmListener
    implements ICcmServiceListener {
        private CcmService date;
        private CcmService time;

        private DateTimeCcmListener() {
        }

        public void ccmSent(CcmService source, Ccm value) {
        }

        public void ccmReceived(CcmService source, Ccm value) {
        }

        public void ccmValueChanged(CcmService source, Ccm value) {
            if (this.date == null && value instanceof DateCcm) {
                this.date = source;
            } else if (this.time == null && value instanceof TimeCcm) {
                this.time = source;
            }
            if (value instanceof TimeCcm && this.date != null && !this.date.isExpired()) {
                int ymd = this.date.getCcm().getNumberValue().intValue();
                int hms = value.getNumberValue().intValue();
                if (hms <= 500) {
                    return;
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                    String dtstr = String.valueOf(String.format("20%6d", ymd)) + String.format("%6d", hms);
                    Date rdate = sdf.parse(dtstr);
                    if (!UecsPiNode.this.timeAdjusted || Math.abs(System.currentTimeMillis() - rdate.getTime()) > 60000L) {
                        if (!UecsPiNode.this.isDevelopmentMode()) {
                            Runtime rt = Runtime.getRuntime();
                            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            rt.exec(new String[]{"sh", "/opt/scripts/change_current_date.sh", sdf.format(this.date)});
                        }
                        UecsPiNode.this.timeAdjusted = true;
                        UecsPiNode.this.logger.info((Object)("DateTime adjusted. value=" + dtstr));
                        UecsPiLogger.log("NODE", "message.datetimeAdjusted", new Object[0]);
                        UecsPiNode.this.restartAsync(1000L);
                    }
                }
                catch (Exception e) {
                    UecsPiNode.this.logger.error((Object)"DateTime adjusting error.", (Throwable)e);
                }
            }
        }

        public void ccmExpired(CcmService source, Ccm value) {
        }
    }

    private class RestartTask
    implements Runnable {
        private List<PiDeviceBase<?>> svlist;
        private long delay;

        public RestartTask(List<PiDeviceBase<?>> devs, long delay) {
            this.svlist = devs;
            this.delay = delay;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
                UecsPiNode.this.logger.debug((Object)"restart node.");
                if (UecsPiNode.this.isActive()) {
                    UecsPiNode.this.stop();
                }
                UecsPiNode.this.setup();
                for (IDevice iDevice : this.svlist) {
                    UecsPiNode.this.addDevice(iDevice);
                }
                UecsPiNode.this.start();
            }
            catch (Exception exception) {
                UecsPiNode.this.logger.error((Object)exception);
            }
        }
    }

    private class UecsPiNodeListener
    implements IUecsNodeListener {
        private UecsPiNodeListener() {
        }

        public void nodeStarted(IUecsNode<?> paramIUecsNode) {
            UecsPiNode.this.logger.info((Object)"node started.");
            UecsPiLogger.log("NODE", "message.nodeStarted", new Object[0]);
        }

        public void nodeStopped(IUecsNode<?> paramIUecsNode) {
            UecsPiNode.this.logger.info((Object)"node stopped.");
            UecsPiLogger.log("NODE", "message.nodeStopped", new Object[0]);
        }

        public void handleNodeException(IUecsNode<?> node, Exception e) {
            UecsPiNode.this.logger.error((Object)"node error.", (Throwable)e);
            UecsPiLogger.log("NODE", "message.alert", e.getMessage());
        }
    }
}

