/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi;

import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.db.LogEntity;
import com.wabit.uecs.pi.util.MessageUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UecsPiLogger {
    public static final String CATEGORY_NODE = "NODE";
    public static final String CATEGORY_DEVICE = "DEVICE";
    public static final String CATEGORY_OTHER = "OTHER";
    private static Log logger = LogFactory.getLog(UecsPiLogger.class);

    private UecsPiLogger() {
    }

    public static List<LogEntity> getLogs(int fetchSize) {
        try {
            return DatabaseUtils.getLogs(fetchSize);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    public static List<LogEntity> getLogs(String category, int fetchSize) {
        try {
            return DatabaseUtils.getLogs(category, fetchSize);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    public static void log(String category, String messageCode, Object ... args) {
        String message = MessageUtils.getMessage(messageCode, args);
        try {
            LogEntity entity = new LogEntity();
            entity.setTime(new Date());
            entity.setCategory(category);
            entity.setMessage(message);
            DatabaseUtils.saveLog(entity);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    public static void clearLogs() {
        try {
            DatabaseUtils.clearLogs();
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }
}

