/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui.top;

import com.wabit.uecs.ActionMode;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.ISwitcher;
import com.wabit.uecs.pi.webui.WebUIApplication;
import com.wabit.uecs.pi.webui.top.ActuatorRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class ActuatorsPanel
extends Panel {
    private static final long serialVersionUID = -3708813079941308934L;

    public ActuatorsPanel(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        ArrayList<ActuatorRow> actList = new ArrayList<ActuatorRow>();
        for (IDevice device : WebUIApplication.getNodeInstance().listDevices()) {
            for (ActuatorComponent actuator : device.listComponents(ActuatorComponent.class)) {
                CcmService oprSv = actuator.getOprServices()[0];
                ActuatorRow rec = new ActuatorRow();
                rec.setName(actuator.getConfig().getString("ComponentName"));
                if (actuator.getActionMode() == ActionMode.Autonomy) {
                    String modeName = actuator.getConfig().getString("ActionMode");
                    if (modeName != null) {
                        rec.setMode(actuator.getConfig().getString("ActionMode"));
                    } else {
                        rec.setMode(actuator.getActionMode().toString());
                    }
                } else {
                    rec.setMode(actuator.getActionMode().toString());
                }
                if (actuator instanceof ISwitcher) {
                    rec.setValue(actuator.getValue() != null && actuator.getValue().intValue() == 1 ? "ON" : "OFF");
                } else if (actuator instanceof IPositioner) {
                    rec.setValue((actuator.getValue() != null ? actuator.getValue() : "") + "[%]");
                } else {
                    String unit;
                    String val = "";
                    if (actuator.getValue() != null) {
                        val = String.valueOf(val) + actuator.getValue().toString();
                    }
                    if ((unit = oprSv.getCcm().getUnit()) != null) {
                        val = String.valueOf(val) + "[" + unit + "]";
                    }
                    rec.setValue(val);
                }
                rec.setUpdateTime(new Date(oprSv.getUpdateTime()));
                actList.add(rec);
            }
        }
        this.add(new Component[]{new ListView<ActuatorRow>("componentList", actList){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<ActuatorRow> item) {
                item.add(new Component[]{new Label("idx", (Serializable)Integer.valueOf(item.getIndex() + 1))});
                item.add(new Component[]{new Label("name", ((ActuatorRow)item.getModelObject()).getName())});
                item.add(new Component[]{new Label("mode", (IModel)new ResourceModel(((ActuatorRow)item.getModelObject()).getMode()))});
                if (((ActuatorRow)item.getModelObject()).getValue() != null) {
                    item.add(new Component[]{new Label("value", ((ActuatorRow)item.getModelObject()).getValue())});
                } else {
                    item.add(new Component[]{new Label("value", "--")});
                }
                if (((ActuatorRow)item.getModelObject()).getUpdateTime() != null) {
                    item.add(new Component[]{DateLabel.forDatePattern((String)"updateTime", (IModel)Model.of((Serializable)((ActuatorRow)item.getModelObject()).getUpdateTime()), (String)"yyyy-MM-dd HH:mm:ss")});
                } else {
                    item.add(new Component[]{new Label("updateTime", "--")});
                }
            }
        }});
    }
}

