/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.serial;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataEventListener;
import com.pi4j.io.serial.impl.SerialImpl;
import com.wabit.uecs.pi.device.serial.SerialPortClientBase;
import com.wabit.uecs.pi.device.serial.SerialPortDeviceConfig;
import com.wabit.uecs.pi.util.BytesUtils;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SerialPortClientPi4jImpl
extends SerialPortClientBase
implements SerialDataEventListener {
    private Log logger = LogFactory.getLog(this.getClass());
    private Serial serial;
    private String portId;
    private int speed;

    @Override
    public void init(SerialPortDeviceConfig conf) throws Exception {
        this.serial = new SerialImpl();
        this.portId = conf.getString("SerialPortId");
        this.speed = conf.getInt("SerialPortSpeed", 9600);
        this.serial.addListener(new SerialDataEventListener[]{this});
    }

    @Override
    public void open() throws Exception {
        this.logger.info((Object)("open port=" + this.portId));
        this.serial.open(this.portId, this.speed);
    }

    @Override
    public void close() throws Exception {
        this.logger.info((Object)("close port=" + this.portId));
        if (!this.serial.isClosed()) {
            this.serial.close();
        }
    }

    @Override
    public void sendData(byte[] data) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("write data : " + BytesUtils.toHexString(data)));
        }
        this.serial.write(data);
    }

    public void dataReceived(SerialDataEvent event) {
        try {
            byte[] data = event.getBytes();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("read size : " + data.length + "bytes"));
                this.logger.debug((Object)("read data : " + BytesUtils.toHexString(data)));
            }
            this.fireDataAvailableEvent(data);
        }
        catch (IOException e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

