/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.i2c;

import com.pi4j.io.i2c.I2CDevice;
import java.io.IOException;

public class I2cUtils {
    private I2cUtils() {
    }

    public static void write(I2CDevice i2cDevice, int tryCount, byte b) throws IOException {
        IOException ex = null;
        while (tryCount > 0) {
            try {
                i2cDevice.write(b);
                return;
            }
            catch (IOException e) {
                ex = e;
                --tryCount;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void write(I2CDevice i2cDevice, int tryCount, byte[] buffer, int offset, int size) throws IOException {
        IOException ex = null;
        while (tryCount > 0) {
            try {
                i2cDevice.write(buffer, offset, size);
                return;
            }
            catch (IOException e) {
                ex = e;
                --tryCount;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static int read(I2CDevice i2cDevice, long waitTime, byte[] buffer, int offset, int size) throws IOException {
        long timeLimit = System.currentTimeMillis() + waitTime;
        int len = 0;
        IOException ex = null;
        while (System.currentTimeMillis() <= timeLimit) {
            try {
                len = i2cDevice.read(buffer, offset, size);
                if (len < size) continue;
                return len;
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return len;
    }
}

