/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.j256.ormlite.dao.Dao;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.wabit.uecs.ActionMode;
import com.wabit.uecs.device.actuator.FixedValueAction;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.pi.db.ComponentConfigEntity;
import com.wabit.uecs.pi.db.ComponentEntity;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.device.ISwitcher;
import com.wabit.uecs.pi.device.gpio.DigitalSwitchActuatorConfig;
import com.wabit.uecs.pi.device.gpio.DigitalSwitchInterlockAction;
import com.wabit.uecs.pi.device.gpio.GpioActuatorBase;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import com.wabit.uecs.pi.webui.WebUIApplication;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigitalSwitchActuator<T extends DigitalSwitchActuatorConfig>
extends GpioActuatorBase<T>
implements ISwitcher {
    private GpioPinDigitalOutput gpioPinSwOutput;
    private GpioPinDigitalInput gpioPinSwInput;
    private Log logger = LogFactory.getLog(this.getClass());

    public DigitalSwitchActuator(String id, T config) {
        super(id, config);
    }

    @Override
    public void on() {
        this.setValue(1);
    }

    @Override
    public void off() {
        this.setValue(0);
    }

    @Override
    public boolean isOn() {
        return this.getValue() != null && this.getValue().intValue() == 1;
    }

    @Override
    public boolean isOff() {
        return this.getValue() == null || this.getValue().intValue() == 0;
    }

    public Pin getSwitchOutputPin() {
        String pinName = ((DigitalSwitchActuatorConfig)this.getConfig()).getString("GpioPinSwOut");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    public Pin getSwitchInputPin() {
        String pinName = ((DigitalSwitchActuatorConfig)this.getConfig()).getString("GpioPinSwIn");
        if (pinName != null && !pinName.isEmpty()) {
            return ((GpioDeviceBase)this.getDevice()).getPin(pinName);
        }
        return null;
    }

    protected boolean getState(double val) {
        boolean state = false;
        if (val >= 1.0) {
            state = true;
        }
        if (this.isInverse()) {
            return !state;
        }
        return state;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.setAction(ActionMode.Interlock, new DigitalSwitchInterlockAction());
        FixedValueAction stdAction = new FixedValueAction();
        stdAction.setValue((Number)((DigitalSwitchActuatorConfig)this.getConfig()).getInt("DefaultValue", 0));
        this.setAction(ActionMode.Standalone, (IActuatorAction)stdAction);
    }

    @Override
    protected void onStart() throws Exception {
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (!WebUIApplication.getNodeInstance().isDevelopmentMode()) {
            Pin pin = this.getSwitchOutputPin();
            if (pin != null && this.gpioPinSwOutput == null) {
                boolean state = this.getState(this.getValue().doubleValue());
                this.gpioPinSwOutput = device.provisionDigitalOutputPin(pin, PinState.getState((boolean)state));
                if (this.gpioPinSwOutput == null) {
                    throw new Exception("GPIO pin not found : " + pin);
                }
            }
            this.logger.debug((Object)("switch_pin(OUTPUT) : " + this.gpioPinSwOutput));
            pin = this.getSwitchInputPin();
            if (pin != null && this.gpioPinSwInput == null) {
                this.gpioPinSwInput = device.provisionDigitalInputPin(pin, PinPullResistance.PULL_UP);
                if (this.gpioPinSwInput == null) {
                    throw new Exception("GPIO pin not found : " + pin);
                }
                this.logger.debug((Object)("switch_pin(INPUT) : " + this.gpioPinSwInput));
            }
        }
        super.onStart();
    }

    @Override
    public void setValue(Number value) {
        if (this.gpioPinSwOutput != null && value != null) {
            this.gpioPinSwOutput.setState(this.getState(value.doubleValue()));
        }
        super.setValue(value);
    }

    @Override
    protected void onStop() throws Exception {
        if (this.getValue() != null) {
            DatabaseManager.callInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Dao compDao = DatabaseManager.createDao(ComponentEntity.class);
                    if (compDao.queryForId((Object)DigitalSwitchActuator.this.getId()) != null) {
                        Dao confDao = DatabaseManager.createDao(ComponentConfigEntity.class);
                        ComponentConfigEntity ent = new ComponentConfigEntity();
                        ent.setComponentId(DigitalSwitchActuator.this.getId());
                        ent.setId(String.valueOf(DigitalSwitchActuator.this.getId()) + "." + "LastValue");
                        ent.setKey("LastValue");
                        ent.setValue(DigitalSwitchActuator.this.getValue().toString());
                        confDao.createOrUpdate((Object)ent);
                    }
                    return null;
                }
            });
        }
        GpioDeviceBase device = (GpioDeviceBase)this.getDevice();
        if (this.gpioPinSwOutput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinSwOutput});
            this.gpioPinSwOutput = null;
        }
        if (this.gpioPinSwInput != null) {
            device.unprovisionPin(new GpioPin[]{this.gpioPinSwInput});
            this.gpioPinSwInput = null;
        }
        super.onStop();
    }

    GpioPinDigitalInput getGpioInputPin() {
        return this.gpioPinSwInput;
    }
}

