/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinEventType;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.pi.device.gpio.DigitalPositioningActuator;
import com.wabit.uecs.pi.device.gpio.DigitalPositioningActuatorConfig;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigitalPositioningInterlockAction
implements IActuatorAction,
GpioPinListenerDigital {
    private DigitalPositioningActuator<?> positioningActuator;
    private long limitTime;
    private Log logger = LogFactory.getLog(this.getClass());

    public synchronized void execute(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioPinDigitalInput upInputPin = this.positioningActuator.getGpioUpInputPin();
        GpioPinDigitalInput downInputPin = this.positioningActuator.getGpioDownInputPin();
        if (upInputPin != null && upInputPin.getState().isLow()) {
            this.logger.debug((Object)"up");
            this.positioningActuator.upPosition(this.limitTime);
        } else if (downInputPin != null && downInputPin.getState().isLow()) {
            this.logger.debug((Object)"down");
            this.positioningActuator.downPosition(this.limitTime);
        } else {
            this.logger.debug((Object)"stop");
            this.positioningActuator.stopPosition();
        }
    }

    public void onStart(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        this.logger.debug((Object)"start");
        if (!(paramActuatorComponent instanceof DigitalPositioningActuator)) {
            throw new IllegalArgumentException("invalid actuator = " + paramActuatorComponent.getClass().getName());
        }
        this.positioningActuator = (DigitalPositioningActuator)paramActuatorComponent;
        this.limitTime = (long)((double)((DigitalPositioningActuatorConfig)this.positioningActuator.getConfig()).getInt("MaxPositionTime", 0) * 1.05) * 1000L;
        this.positioningActuator.stopPosition();
        GpioDeviceBase device = (GpioDeviceBase)this.positioningActuator.getDevice();
        if (this.positioningActuator.getGpioUpInputPin() != null) {
            device.addListener((GpioPinListener)this, (GpioPinInput)this.positioningActuator.getGpioUpInputPin());
        }
        if (this.positioningActuator.getGpioDownInputPin() != null) {
            device.addListener((GpioPinListener)this, (GpioPinInput)this.positioningActuator.getGpioDownInputPin());
        }
        this.execute(paramActuatorComponent);
    }

    public void onStop(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        this.logger.debug((Object)"stop");
        this.positioningActuator.stopPosition();
        GpioDeviceBase device = (GpioDeviceBase)this.positioningActuator.getDevice();
        if (this.positioningActuator.getGpioUpInputPin() != null) {
            device.removeListener((GpioPinListener)this, (GpioPinInput)this.positioningActuator.getGpioUpInputPin());
        }
        if (this.positioningActuator.getGpioDownInputPin() != null) {
            device.removeListener((GpioPinListener)this, (GpioPinInput)this.positioningActuator.getGpioDownInputPin());
        }
    }

    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Event=" + event.toString()));
        }
        if (event.getEventType() == PinEventType.DIGITAL_STATE_CHANGE) {
            try {
                this.execute(this.positioningActuator);
            }
            catch (Exception e) {
                this.logger.error((Object)"process faild.", (Throwable)e);
            }
        }
    }
}

