/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.IGenericComponent;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.Strings;

public class Radio<T>
extends LabeledWebMarkupContainer
implements IGenericComponent<T> {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_DISABLED = "disabled";
    private int uuid = -1;
    private final RadioGroup<T> group;

    public Radio(String id) {
        this(id, null, null);
    }

    public Radio(String id, IModel<T> model) {
        this(id, model, null);
    }

    public Radio(String id, RadioGroup<T> group) {
        this(id, null, group);
    }

    public Radio(String id, IModel<T> model, RadioGroup<T> group) {
        super(id, model);
        this.group = group;
        this.setOutputMarkupId(true);
    }

    public String getValue() {
        if (this.uuid < 0) {
            this.uuid = this.getPage().getAutoIndex();
        }
        return "radio" + this.uuid;
    }

    protected RadioGroup<T> getGroup() {
        RadioGroup group = this.group;
        if (group == null && (group = this.findParent(RadioGroup.class)) == null) {
            throw new WicketRuntimeException("Radio component [" + this.getPath() + "] cannot find its parent RadioGroup. All Radio components must be a child of or below in the hierarchy of a RadioGroup component.");
        }
        return group;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        this.checkComponentTagAttribute(tag, "type", "radio");
        String value = this.getValue();
        RadioGroup<T> group = this.getGroup();
        tag.put("name", group.getInputName());
        tag.put("value", value);
        if (group.hasRawInput()) {
            String rawInput = group.getRawInput();
            if (rawInput != null && rawInput.equals(value)) {
                tag.put("checked", "checked");
            }
        } else if (group.getModelComparator().compare(group, this.getDefaultModelObject())) {
            tag.put("checked", "checked");
        }
        if (group.wantOnSelectionChangedNotifications()) {
            CharSequence url = group.urlFor(IOnChangeListener.INTERFACE, new PageParameters());
            Form form = group.findParent(Form.class);
            if (form != null) {
                tag.put("onclick", form.getJsForInterfaceUrl(url));
            } else {
                tag.put("onclick", "window.location.href='" + url + (((Object)url).toString().indexOf(63) > -1 ? "&" : "?") + group.getInputName() + "=' + this.value;");
            }
        }
        if (!this.isEnabledInHierarchy()) {
            tag.put(ATTR_DISABLED, ATTR_DISABLED);
        }
        String marker = "wicket-" + this.getGroup().getMarkupId();
        String clazz = tag.getAttribute("class");
        clazz = Strings.isEmpty((CharSequence)clazz) ? marker : clazz + " " + marker;
        tag.put("class", clazz);
    }

    @Override
    public Radio<T> setLabel(IModel<String> labelModel) {
        super.setLabel(labelModel);
        return this;
    }

    @Override
    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    @Override
    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    @Override
    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    @Override
    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

