/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptUrlReferenceHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class JavaScriptHeaderItem
extends HeaderItem {
    private final String condition;

    protected JavaScriptHeaderItem(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference) {
        return JavaScriptHeaderItem.forReference(reference, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, String id) {
        return JavaScriptHeaderItem.forReference(reference, null, id);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id) {
        return JavaScriptHeaderItem.forReference(reference, pageParameters, id, false);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer) {
        return JavaScriptHeaderItem.forReference(reference, pageParameters, id, defer, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, String id, boolean defer) {
        return JavaScriptHeaderItem.forReference(reference, null, id, defer, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, boolean defer) {
        return JavaScriptHeaderItem.forReference(reference, null, null, defer, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer, String charset) {
        return new JavaScriptReferenceHeaderItem(reference, pageParameters, id, defer, charset, null);
    }

    public static JavaScriptReferenceHeaderItem forReference(ResourceReference reference, PageParameters pageParameters, String id, boolean defer, String charset, String condition) {
        return new JavaScriptReferenceHeaderItem(reference, pageParameters, id, defer, charset, condition);
    }

    public static JavaScriptContentHeaderItem forScript(CharSequence javascript, String id) {
        return JavaScriptHeaderItem.forScript(javascript, id, null);
    }

    public static JavaScriptContentHeaderItem forScript(CharSequence javascript, String id, String condition) {
        return new JavaScriptContentHeaderItem(javascript, id, condition);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url) {
        return JavaScriptHeaderItem.forUrl(url, null);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id) {
        return JavaScriptHeaderItem.forUrl(url, id, false);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id, boolean defer) {
        return JavaScriptHeaderItem.forUrl(url, id, defer, null);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id, boolean defer, String charset) {
        return JavaScriptHeaderItem.forUrl(url, id, defer, charset, null);
    }

    public static JavaScriptUrlReferenceHeaderItem forUrl(String url, String id, boolean defer, String charset, String condition) {
        return new JavaScriptUrlReferenceHeaderItem(url, id, defer, charset, condition);
    }

    @Deprecated
    protected final void internalRenderJavaScriptReference(Response response, String url, String id, boolean defer, String charset, String condition) {
        this.internalRenderJavaScriptReference(response, url, id, defer, charset, condition, false);
    }

    protected final void internalRenderJavaScriptReference(Response response, String url, String id, boolean defer, String charset, String condition, boolean async) {
        boolean hasCondition;
        Args.notEmpty((CharSequence)url, (String)"url");
        boolean bl = hasCondition = !Strings.isEmpty((CharSequence)condition);
        if (hasCondition) {
            response.write((CharSequence)"<!--[if ");
            response.write((CharSequence)condition);
            response.write((CharSequence)"]>");
        }
        boolean isAjax = RequestCycle.get().find(AjaxRequestTarget.class) != null;
        CharSequence escapedUrl = isAjax ? Strings.escapeMarkup((CharSequence)url) : url;
        JavaScriptUtils.writeJavaScriptUrl(response, escapedUrl, id, defer, charset, async);
        if (hasCondition) {
            response.write((CharSequence)"<![endif]-->\n");
        }
    }
}

