/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.util.string.Strings;

public final class WicketTagIdentifier
extends AbstractMarkupFilter {
    private static final Set<String> WELL_KNOWN_TAG_NAMES = new HashSet<String>();

    public WicketTagIdentifier(MarkupResourceStream markup) {
        super(markup);
    }

    @Override
    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        String namespace = this.getWicketNamespace();
        String wicketIdValue = tag.getAttributes().getString(namespace + ":id");
        if (namespace.equalsIgnoreCase(tag.getNamespace())) {
            tag = new WicketTag(tag.getXmlTag());
            if (Strings.isEmpty((CharSequence)wicketIdValue)) {
                tag.setId(namespace + "_" + tag.getName());
                tag.setModified(true);
                if (!tag.isClose()) {
                    tag.setAutoComponentTag(true);
                }
            }
            if (!this.isWellKnown(tag)) {
                throw new WicketParseException("Unknown tag name with Wicket namespace: '" + tag.getName() + "'. Might be you haven't installed the appropriate resolver?", tag);
            }
        }
        if (wicketIdValue != null) {
            if (wicketIdValue.trim().length() == 0) {
                throw new WicketParseException("The wicket:id attribute value must not be empty. May be unmatched quotes?!?", tag);
            }
            tag.setId(wicketIdValue);
        }
        return tag;
    }

    public static void registerWellKnownTagName(String name) {
        String lowerCaseName = name.toLowerCase(Locale.ENGLISH);
        WELL_KNOWN_TAG_NAMES.add(lowerCaseName);
    }

    private boolean isWellKnown(ComponentTag tag) {
        String lowerCaseTagName = tag.getName().toLowerCase(Locale.ENGLISH);
        return WELL_KNOWN_TAG_NAMES.contains(lowerCaseTagName);
    }

    static {
        WELL_KNOWN_TAG_NAMES.add("border");
        WELL_KNOWN_TAG_NAMES.add("body");
        WELL_KNOWN_TAG_NAMES.add("label");
        WELL_KNOWN_TAG_NAMES.add("panel");
        WELL_KNOWN_TAG_NAMES.add("enclosure");
        WELL_KNOWN_TAG_NAMES.add("link");
        WELL_KNOWN_TAG_NAMES.add("remove");
        WELL_KNOWN_TAG_NAMES.add("fragment");
        WELL_KNOWN_TAG_NAMES.add("head");
        WELL_KNOWN_TAG_NAMES.add("header-items");
        WELL_KNOWN_TAG_NAMES.add("child");
        WELL_KNOWN_TAG_NAMES.add("extend");
        WELL_KNOWN_TAG_NAMES.add("container");
        WELL_KNOWN_TAG_NAMES.add("message");
    }
}

