/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class AjaxFormChoiceComponentUpdatingBehavior
extends AjaxFormComponentUpdatingBehavior {
    private static final ResourceReference CHOICE_JS = new JavaScriptResourceReference(AjaxFormChoiceComponentUpdatingBehavior.class, "AjaxFormChoiceComponentUpdatingBehavior.js");
    private static final long serialVersionUID = 1L;

    public AjaxFormChoiceComponentUpdatingBehavior() {
        super("click");
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(JavaScriptHeaderItem.forReference(CHOICE_JS));
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.getAjaxCallListeners().add(new AjaxCallListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public CharSequence getPrecondition(Component component) {
                return String.format("return Wicket.Choice.acceptInput('%s', attrs)", AjaxFormChoiceComponentUpdatingBehavior.this.getFormComponent().getInputName());
            }
        });
        attributes.getDynamicExtraParameters().add(String.format("return Wicket.Choice.getInputValues('%s', attrs)", this.getFormComponent().getInputName()));
    }

    @Override
    protected void onBind() {
        super.onBind();
        if (this.getComponent() instanceof RadioGroup || this.getComponent() instanceof CheckGroup) {
            this.getComponent().setRenderBodyOnly(false);
        }
    }

    @Override
    protected void checkComponent(FormComponent<?> component) {
        if (!AjaxFormChoiceComponentUpdatingBehavior.appliesTo(this.getComponent())) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a RadioChoice/CheckboxChoice/RadioGroup/CheckGroup");
        }
    }

    static boolean appliesTo(Component component) {
        return component instanceof RadioChoice || component instanceof CheckBoxMultipleChoice || component instanceof RadioGroup || component instanceof CheckGroup;
    }
}

